document.getElementById("terms").addEventListener("change", function() {
    const isChecked = this.checked;
    const downloadButton = document.getElementById("downloadButton");
    
    if (isChecked) {
        // Enable download button
        downloadButton.disabled = false;
    } else {
        // Disable download button
        downloadButton.disabled = true;
    }
});

document.getElementById("downloadButton").addEventListener("click", function() {
    // Trigger the download of the file
    window.location.href = "terms_and_conditions.pdf";
    
    // Show a confirmation popup asking the user to confirm they read the terms
    const confirmRead = confirm("Please confirm you have read the Terms and Conditions.");
    
    if (confirmRead) {
        // Enable the swap button after confirmation
        document.getElementById("swapButton").disabled = false;
    } else {
        // Disable swap button if not confirmed
        document.getElementById("swapButton").disabled = true;
    }
});
